//
//  ChangePinViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class ChangePinViewController: BaseViewController {

    @IBOutlet weak var containerView: UIView!
    @IBOutlet weak var currentPinField: UITextField!
    @IBOutlet weak var newPinField: UITextField!
    @IBOutlet weak var confirmationPinField: UITextField!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Change PIN"
        self.containerView.isHidden = true

        startChangePin()
    }
    
    func startChangePin() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startChangePin()
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.containerView.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }
    }
    
    func finalizeChangePin(currentPin: String, newPin: String) {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.finalizeChangePin(currentPin: currentPin, newPin: newPin)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.resetBioKey(pin: newPin)
                    self.showAlert(title: "Change Pin", message: "Success")
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    func resetBioKey(pin: String) {
        let pinMode = InweboService.sharedInstance.getPinMode()
        if (pinMode & IW_PINMODE_BIO) != 0 {
            DispatchQueue.global().async {
                let startResult = InweboService.sharedInstance.startUnsetBiokey()
                if startResult == IW_ERR_OK && BiokeyService.sharedInstance.deleteBiokey() {
                    let finalizeResult = InweboService.sharedInstance.finalizeUnsetBiokey(pin: pin)
                    if startResult != IW_ERR_OK {
                        DispatchQueue.main.async {
                            self.showErrorFor(code: finalizeResult)
                        }
                    }
                } else {
                    DispatchQueue.main.async {
                        self.showErrorFor(code: startResult)
                    }
                }
            }
        }
    }
    
    @IBAction func updateTouched(_ sender: Any) {
        let currentPin = self.currentPinField.text ?? ""
        let newPin = self.newPinField.text ?? ""
        let newPinConfirmation = self.confirmationPinField.text ?? ""
        
        guard newPin.isValidPin() else {
            self.showAlert(title: "Error", message: "PIN must be 4 digits minimum, 6 maximum")
            return
        }
        
        guard newPinConfirmation == newPin else {
            self.showAlert(title: "Error", message: "PIN values are not the same")
            return
        }
        
        finalizeChangePin(currentPin: currentPin, newPin: newPin)
    }
}
